<?php
function tgl_indo($tanggal){
    $bulan = array (
        1 => 'Januari',
        'Februari',
        'Maret',
        'April',
        'Mei',
        'Juni',
        'Juli',
        'Agustus',
        'September',
        'Oktober',
        'November',
        'Desember'
    );
    $pecahkan = explode('-', $tanggal);
    return $pecahkan[2] . ' ' . $bulan[ (int)$pecahkan[1] ] . ' ' . $pecahkan[0];
}
?>

<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title><?= $judul ?></title>
    <style>
        body {
            font-family: "Trebuchet MS", Arial, Helvetica, sans-serif;
            font-size: 12px;
        }
        #customers {
            border-collapse: collapse;
            width: 100%;
        }
        #customers th, #customers td {
            border: 1px solid #ddd;
            padding: 8px;
        }
        #customers th {
            background-color: #858796;
            color: white;
            text-align: left;
        }
        #customers tr:nth-child(even){
            background-color: #f2f2f2;
        }
        #customers tr:hover {
            background-color: #ddd;
        }
        .logo {
            width: 80px;
            margin-bottom: 10px;
        }
        .center-text {
            text-align: center;
        }
    </style>
</head>
<body>

<!-- Logo dan Judul -->
<table border="0" width="100%">
    <tr>
        <td width="15%">
            <img src="<?= base_url('assets/icon/logo8.jpeg') ?>" class="logo" alt="Logo" style="width:80px;">
        </td>
        <td width="85%" style="vertical-align: middle; text-align: center;">
            <h2 style="margin-bottom: 0;"><?= $judul ?></h2>
            <?php if($tglawal == '' || $tglakhir == ''): ?>
                <small>Semua Tanggal</small>
            <?php else: ?>
                <small><?= tgl_indo($tglawal) ?> - <?= tgl_indo($tglakhir) ?></small>
            <?php endif; ?>
        </td>
    </tr>
</table>


<br>

<!-- Tabel Data -->
<table id="customers">
    <thead>
        <tr>
            <th>No</th>
            <th>Tanggal Keluar</th>
            <th>No.Transaksi</th>
            <th>Nama Barang</th>
            <th>Jumlah Keluar</th>
        </tr>
    </thead>
    <tbody>
        <?php $no=1; foreach ($data as $d): ?>
        <tr>
            <td><?= $no++ ?></td>
            <td><?= tgl_indo($d->tgl_keluar) ?></td>
            <td><?= $d->id_barang_keluar ?></td>
            <td><?= $d->nama_barang ?></td>
            <td><?= $d->jumlah_keluar ?></td>
        </tr>
        <?php endforeach; ?>
    </tbody>
</table>

<!-- Tanda Tangan -->
<br><br><br>
<table width="100%">
    <tr>
         <td width="50%" style="text-align: center;">
              <strong>Admin Gudang</strong><br><br><br><br>
            (............................)
        </td>
         <td width="50%" style="text-align: center;">
                 <strong>Manajer</strong><br><br><br><br>
            (............................)
        </td>
    </tr>
</table>

</body>
</html>
