<?php
function tgl_indo($tanggal){
    $bulan = array (
        1 => 'Januari', 'Februari', 'Maret', 'April', 'Mei', 'Juni',
        'Juli', 'Agustus', 'September', 'Oktober', 'November', 'Desember'
    );
    $pecahkan = explode('-', $tanggal);
    return $pecahkan[2] . ' ' . $bulan[ (int)$pecahkan[1] ] . ' ' . $pecahkan[0];
}
?>

<!DOCTYPE html>
<html>
<head>
    <title><?= $judul ?></title>
    <style>
        body {
            font-family: "Trebuchet MS", Arial, Helvetica, sans-serif;
            font-size: 12px;
        }

        #customers {
            border-collapse: collapse;
            width: 100%;
        }

        #customers th, #customers td {
            border: 1px solid #ddd;
            padding: 8px;
        }

        #customers th {
            background-color: #858796;
            color: white;
            text-align: left;
        }

        #customers tr:nth-child(even) {
            background-color: #f2f2f2;
        }

        #customers tr:hover {
            background-color: #ddd;
        }
    </style>
</head>
<body>

<!-- Header: Logo + Judul -->
<table width="100%" border="0">
    <tr>
        <td width="15%" align="center">
            <img src="<?= base_url('assets/icon/logo8.jpeg') ?>" width="80" alt="Logo">
        </td>
        <td width="85%" align="center">
            <h2><?= $judul ?></h2>
            <?php if($tglawal == '' || $tglakhir == ''): ?>
                <small>Semua Tanggal</small>
            <?php else: ?>
                <small><?= tgl_indo($tglawal) ?> - <?= tgl_indo($tglakhir) ?></small>
            <?php endif; ?>
        </td>
    </tr>
</table>

<br>

<!-- Tabel Data -->
<table id="customers">
    <thead>
        <tr>
            <th>No</th>
            <th>Tanggal Masuk</th>
            <th>No. Transaksi</th>
            <th>Supplier</th>
            <th>Nama Barang</th>
            <th>Jumlah Masuk</th>
        </tr>
    </thead>
    <tbody>
        <?php $no = 1; foreach ($data as $d): ?>
        <tr>
            <td><?= $no++ ?></td>
            <td><?= tgl_indo($d->tgl_masuk) ?></td>
            <td><?= $d->id_barang_masuk ?></td>
            <td><?= $d->nama_supplier ?></td>
            <td><?= $d->nama_barang ?></td>
            <td><?= $d->jumlah_masuk ?></td>
        </tr>
        <?php endforeach; ?>
    </tbody>
</table>

<!-- Tanda Tangan -->
<br><br><br>
<table width="100%">
    <tr>
        <td width="50%" style="text-align: center;">
            <strong>Admin Gudang</strong><br><br><br><br>
            (............................)
        </td>
        <td width="50%" style="text-align: center;">
            <strong>Manajer</strong><br><br><br><br>
            (............................)
        </td>
    </tr>
</table>

</body>
</html>
